define("core_form/dynamicform",["exports","core_form/changechecker","core_form/events","core/ajax","core/fragment","core/notification","core/pending","core/templates","core/str","./util"],(function(_exports,FormChangeChecker,FormEvents,_ajax,_fragment,_notification,_pending,_templates,_str,_util){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,FormChangeChecker=_interopRequireWildcard(FormChangeChecker),FormEvents=_interopRequireWildcard(FormEvents),_ajax=_interopRequireDefault(_ajax),_fragment=_interopRequireDefault(_fragment),_notification=_interopRequireDefault(_notification),_pending=_interopRequireDefault(_pending),_templates=_interopRequireDefault(_templates);return _exports.default=class{constructor(container,formClass){var obj,key,value;value={FORM_SUBMITTED:"core_form_dynamicform_formsubmitted",FORM_CANCELLED:"core_form_dynamicform_formcancelled",CLIENT_VALIDATION_ERROR:"core_form_dynamicform_clientvalidationerror",SERVER_VALIDATION_ERROR:"core_form_dynamicform_validationerror",ERROR:"core_form_dynamicform_error",NOSUBMIT_BUTTON_PRESSED:"core_form_dynamicform_nosubmitbutton",SUBMIT_BUTTON_PRESSED:"core_form_dynamicform_submitbutton",CANCEL_BUTTON_PRESSED:"core_form_dynamicform_cancelbutton"},(key="events")in(obj=this)?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,this.formClass=formClass,this.container=container,(0,_str.get_strings)([{key:"collapseall",component:"moodle"},{key:"expandall",component:"moodle"}]).catch(_notification.default.exception),this.container.addEventListener("click",(e=>{if(e.target.matches("form input[type=submit][data-cancel]")){e.preventDefault();this.trigger(this.events.CANCEL_BUTTON_PRESSED,e.target).defaultPrevented||this.processCancelButton()}else if(e.target.matches('form input[type=submit][data-no-submit="1"]')){e.preventDefault();this.trigger(this.events.NOSUBMIT_BUTTON_PRESSED,e.target).defaultPrevented||this.processNoSubmitButton(e.target)}})),this.container.addEventListener("submit",(e=>{if(e.target.matches("form")){e.preventDefault();this.trigger(this.events.SUBMIT_BUTTON_PRESSED).defaultPrevented||this.submitFormAjax()}}))}load(){let args=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const formData=(0,_util.serialize)(args||{}),pendingPromise=new _pending.default("core_form/dynamicform:load");return this.getBody(formData).then((resp=>this.updateForm(resp))).then(pendingPromise.resolve)}trigger(eventName){const e=new CustomEvent(eventName,{detail:arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,cancelable:!(arguments.length>2&&void 0!==arguments[2])||arguments[2]});return this.container.dispatchEvent(e),e}addEventListener(){this.container.addEventListener(...arguments)}getBody(formDataString){return _ajax.default.call([{methodname:"core_form_dynamic_form",args:{formdata:formDataString,form:this.formClass}}])[0].then((response=>({html:response.html,js:_fragment.default.processCollectedJavascript(response.javascript)})))}onSubmitSuccess(response){this.trigger(this.events.FORM_SUBMITTED,response).defaultPrevented||(this.container.innerHTML="")}onSubmitError(exception){this.trigger(this.events.ERROR,exception).defaultPrevented||_notification.default.exception(exception)}processNoSubmitButton(button){const pendingPromise=new _pending.default("core_form/dynamicform:nosubmit"),form=this.getFormNode(),formData=new URLSearchParams([...new FormData(form).entries()]);formData.append(button.getAttribute("name"),button.getAttribute("value")),FormEvents.notifyFormSubmittedByJavascript(form,!0),this.disableButtons(),this.getBody(formData.toString()).then(this.updateForm).then(pendingPromise.resolve).catch((exception=>this.onSubmitError(exception)))}getFormNode(){return this.container.querySelector("form")}notifyResetFormChanges(){FormEvents.notifyFormSubmittedByJavascript(this.getFormNode(),!0),FormChangeChecker.resetFormDirtyState(this.getFormNode())}processCancelButton(){this.notifyResetFormChanges();this.trigger(this.events.FORM_CANCELLED).defaultPrevented||(this.container.innerHTML="")}updateForm(_ref){let{html:html,js:js}=_ref;return _templates.default.replaceNodeContents(this.container,html,js)}validateElements(){FormEvents.notifyFormSubmittedByJavascript(this.getFormNode());const invalid=[...this.container.querySelectorAll('[aria-invalid="true"], .error')];return!invalid.length||(invalid[0].focus(),!1)}disableButtons(){this.container.querySelectorAll('form input[type="submit"]').forEach((el=>el.setAttribute("disabled",!0)))}enableButtons(){this.container.querySelectorAll('form input[type="submit"]').forEach((el=>el.removeAttribute("disabled")))}async submitFormAjax(){if(!await this.validateElements())return void this.trigger(this.events.CLIENT_VALIDATION_ERROR,null,!1);this.disableButtons();const form=this.container.querySelector("form"),formData=new URLSearchParams([...new FormData(form).entries()]);_ajax.default.call([{methodname:"core_form_dynamic_form",args:{formdata:formData.toString(),form:this.formClass}}])[0].then((response=>{if(response.submitted){const data=JSON.parse(response.data);this.enableButtons(),this.notifyResetFormChanges(),this.onSubmitSuccess(data)}else this.updateForm({html:response.html,js:_fragment.default.processCollectedJavascript(response.javascript)}),this.enableButtons(),this.trigger(this.events.SERVER_VALIDATION_ERROR,null,!1);return null})).catch((exception=>this.onSubmitError(exception)))}},_exports.default}));

//# sourceMappingURL=dynamicform.min.js.map